﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;
using VeteransAffairs.Registries.BusinessManager.MDWS; // Add 29-Oct-2010 per JH
using System.Text;
using System.Configuration;
using System.Runtime.InteropServices;
using Telerik.Web.UI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_InstrumentFollowUpEntry : BaseTBIInstrumentPage
{

    #region Variable Declarations

    private const string FailedFormValuesName = "FollowUpFailedFormValues";
    private const string DeferredMessageKeyName = "FollowUpDeferredMessageKey";
    protected string _serviceToUse = Helpers.getCurrentServiceToUse(); //ConfigurationManager.AppSettings["TBIServiceToUse"].ToString();
    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();
    protected int _surveyTypeId = 3; // Database Id for Follow  Up Entry
    protected int selectedItems = 0;
    protected List<string> _ThirteenAAnswers, _FiveDFiveAAnswers;
    SURVEY _survey;   // the root object in the Survey set

    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_InstrumentFollowUpEntry()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods

    void InitializeDataSources(Control control)
    {
        foreach (Control child in control.Controls)
        {
            ObjectDataSource ds = child as ObjectDataSource;
            if (ds != null && ds.SelectMethod.Equals("GetChoicesByQuestionNumberandSurveyType", StringComparison.OrdinalIgnoreCase))
            {
                ds.TypeName = "VeteransAffairs.Registries.QuestionChoiceRetriever";
                //ds.TypeName = this.GetType().AssemblyQualifiedName;
                //ds.ObjectCreating += ObjectDataSource_ObjectCreating;
            }
            InitializeDataSources(child);
        }
    }

    protected void Page_Init(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(_tbiInstrumentManager, _surveyTypeId);
        InitializeDataSources(this);
    }

    protected void Page_Unload(object sender, EventArgs e)
    {
        VeteransAffairs.Registries.QuestionChoiceRetriever.Reset(null, -1);
    }

    bool preventNotification = false;
    protected void Page_PreRenderComplete(object sender, EventArgs e)
    {
        if (!Page.IsPostBack && Helpers.SetupPageFromCache(this, FailedFormValuesName))
        {
            SuppressSaveMessage = false;
            SaveFailMessage = "Unable to save the survey.\r\n\r\nThere may be network issues preventing you from saving.\r\n\r\nPlease try to submit your changes again.";
            RenderStartUpMessage(false);
        }
        else if (Page.IsPostBack && !preventNotification)
        {
            DeferredMessage = "Save was Successful!";
        }
        else if (DeferredMessage != null)
        {
            SuppressSaveMessage = false;
            SaveSuccessMessage = DeferredMessage;
            RenderStartUpMessage(true);
            DeferredMessage = null;
        }
    }

    private static string DeferredMessage
    {
        get { return HttpContext.Current.Session[DeferredMessageKeyName] as string; }
        set { HttpContext.Current.Session[DeferredMessageKeyName] = value; }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            string instTitle = String.Empty;
            _ThirteenAAnswers = new List<string>(11); 
            _FiveDFiveAAnswers = new List<string>(8);

            _tbiInstrumentManager.TbiServiceTo = base.GetTBIServiceTo();
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("InstrumentFollowUpEntry.Page_Load(): _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;
            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (!IsPostBack)
            {
                //These are DataBound controls and need viewstate
                rblMedicationReconciliationPerformed.EnableViewState = true;
                rblMedicationGiven.EnableViewState = true;

                LoadRadioButtonListItems(rblMedicationReconciliationPerformed, "16-A");
                LoadRadioButtonListItems(rblMedicationGiven, "16-B");

                string _snum = string.Empty;

                base.AddtoViewStateTBIServiceTo(_tbiInstrumentManager.TbiServiceTo);

                if (instrumentType.Status != null)
                {
                    _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
                }
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);

                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                if (labelUser != null)
                {
                    labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);
                }

                if (!string.IsNullOrEmpty(_snum))
                {
                    string patICN = patientManager.GetPatientICNBySnum(_snum);

                    if (!string.IsNullOrEmpty(patICN))
                    {
                        ViewState["PatientICN"] = patICN;
                        RefreshSurvey(patICN);
                    }
                    else
                    {
                        throw new ArgumentException("Patient with this SSN does not exist.");
                    }

                    if (_survey != null && !_survey.isNew)
                    {
                        SetUpSurvey(_survey);
                    }
                    string referrer = "";
                    if (Request.UrlReferrer != null)
                    {
                        referrer = Request.UrlReferrer.PathAndQuery;
                    }
                    ViewState["referrer"] = referrer;
                }

                InjuryYearRangeValidator.MinimumValue = "2001";
                InjuryYearRangeValidator.MaximumValue = DateTime.Today.Year.ToString();
            }
        }
        catch (Exception ex)
        {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentFollowUpEntry.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2");
        }
    }

    private void LoadRadioButtonListItems(RadioButtonList rbl, string questionNumber)
    {
        List<STD_QUESTION_CHOICE> list = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
        list.RemoveAt(0);
        rbl.DataSource = list;
        rbl.DataBind();
    }

    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState()
    {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e)
    {
        //Page.Validate();
        //if (Page.IsValid)
        //{
        Int32 status = 0;
        //SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveFailMessage = "Save Succeeded";

        if (e.GetType().TypeHandle.Value.ToString().Length > 0)
        {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("InstrumentFollowUpEntry.aspx", false);
        }
        //}
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
        try
        {
            Int32 status = 0;
            SaveFailMessage = "Save Successful";
            SaveCompleteSurvey(ref status);
            if (status > 0)
            {
                preventNotification = true;
                Session["survey"] = _survey;
                Response.Redirect("InstrumentSummaryNote.aspx", false);
            }
            else
            {
                //SetUpSurvey(_survey); //Follow Save Draft logic 
                Response.Redirect("InstrumentFollowUpEntry.aspx", false);
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentFollowUpEntry.aspx", "100030", "btnSubmit_Click()");
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");

        Response.Redirect("Instrument.aspx", false);
    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleInstructions_OnClick(object sender, EventArgs e)
    {

    }

    /// <summary>
    /// Calculate button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCalculate_Click(object sender, EventArgs e)
    {

    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e)
    {
        preventNotification = true;
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        //Page.Validate();

        //if (Page.IsValid)
        //{
        SaveCompleteSurvey(ref status);
        //SetUpSurvey(_survey);
        Response.Redirect("InstrumentFollowUpEntry.aspx", false);
        //}
        //else
        //{
        //    SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        //}
    }

    #endregion

    #region Private Methods

    //Replaces calls to GetChoicesByQuestionNumberandSurveyType
    private List<STD_QUESTION_CHOICE> GetQuestionChoices(string questionNumber)
    {
        return VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN)
    {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();
        if (surveys.Count > 0)
            _survey = surveys.First();
        else
            _survey = new SURVEY();
        _survey.SetAsChangeTrackingRoot();
    }


    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status)
    {
        try
        {
            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("InstrumentFollowUpEntry.SaveCompeletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2");
                }
            }
            else
            {
                Logging.WriteLogToFile("InstrumentFollowUpEntry.SaveCompeletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }


            if (_survey != null)
            {
                if (_survey.isNew)
                {

                    //int _surveycount = 0;
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
                    //{
                    //    var surveys = _tbiVIAInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();
                    //    //_surveycount = surveys.Count;
                    //}
                    //else
                    //{
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();
                    //_surveycount = surveys.Count;
                    //}

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("InstrumentFollowUpEntry.SaveCompeletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9");
                    }
                    else
                    {
                        _survey.SURVEY_STATUS = "inprocess";
                        _survey.SetAsInsertOnSubmit();
                        _survey.patient_ICN = patientICN;
                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;

                        //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
                        //    _tbiVIAInstrumentManager.Update(_survey);
                        //else
                        _tbiInstrumentManager.Update(_survey);

                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();

                //if (!String.IsNullOrEmpty(_serviceToUse) && _serviceToUse.Contains("VIA"))
                //    status = _tbiVIAInstrumentManager.Update(_survey);
                //else
                status = _tbiInstrumentManager.Update(_survey);

                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
        catch (Exception ex)
        {

            Exception _tbilogerror = HandleTBIException(ex, "InstrumentFollowUpEntry.aspx", "100026", "SaveCompleteSurvey()");
        }
        finally
        {
            if (status == 0)
            {
                Helpers.SavePageToCache(this, FailedFormValuesName);
            }
            else
                Session[FailedFormValuesName] = null;//clear out the cached version on success
        }
    }

    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey)
    {
        survey.SetAsChangeTrackingRoot();
        foreach (SURVEY_RESULT tempResult in survey.SURVEY_RESULTs)
            tempResult.SetAsDeleteOnSubmit();
        List<STD_QUESTION> questions = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions();
        //Instead of performing the delete now, wait until updates are applied.
        //Some updates might just remove the delete operation, reducing the total number of operations.

        SaveText(survey, questions, "A", TextBoxChiefComplaint);
        SaveText(survey, questions, "B", TextBoxHistoryPresentIllness);
        SaveSingleSelect(survey, questions, "1", RadioButtonListChangeInMaritalStatus);
        SaveSingleSelect(survey, questions, "2", RadioButtonListHighestEducationalLevel);
        SaveSingleSelect(survey, questions, "2-A", RadioButtonListCurrentSchool);
        SaveSingleSelect(survey, questions, "3", RadioButtonListCurrentEmploymentStatus);
        SaveSingleSelect(survey, questions, "4", rblExperiencedHeadInjury);
        if (rblExperiencedHeadInjury.SelectedItem != null && rblExperiencedHeadInjury.SelectedItem.Text == "Yes")
        {
            SaveText(survey, questions, "4-A", tbxMonthOfRecentHeadInjury);
            SaveText(survey, questions, "4-B", tbxYearOfRecentHeadInjury);
            SaveSingleSelect(survey, questions, "5-A", rblBullet);
            SaveSingleSelect(survey, questions, "5-B", rblVehicular);
            SaveSingleSelect(survey, questions, "5-C", rblFall);
            SaveSingleSelect(survey, questions, "5-D", rblBlastOccurrences);
            SaveSingleSelect(survey, questions, "5-D-1", rblBlastWaveExperience);
            SaveSingleSelect(survey, questions, "5-D-1-A", rblEstimatedBlastDistance);
            SaveSingleSelect(survey, questions, "5-D-2", rblBlastWaveWindExperience);
            SaveSingleSelect(survey, questions, "5-D-3", rblBlastWaveCausingViolentImpact);
            SaveSingleSelect(survey, questions, "5-D-4", rblBlastExplosionCausingInjuries);
            SaveMultiSelect(survey, questions, "5-D-5", CheckBoxListTypeOfBlastExposures, rblExperiencedHeadInjury.SelectedValue == "4736" || rblBlastOccurrences.SelectedValue == "4763");
            SaveSingleSelect(survey, questions, "5-E", rblBluntTraumaOtherThanFromBlast);
            SaveSingleSelect(survey, questions, "6", rblLossOfConsciousness);
            if (rblLossOfConsciousness.SelectedItem != null && rblLossOfConsciousness.SelectedItem.Text != "No" && rblLossOfConsciousness.SelectedItem.Text != "Uncertain" && rblLossOfConsciousness.SelectedItem.Text != "Other condition not related to TBI or Behavioral Health condition(s)")
            {
                SaveSingleSelect(survey, questions, "6-A", rblDurationLossOfConsciousness);
            }
            SaveSingleSelect(survey, questions, "7", rblDisorientationOrConfusion);
            if (rblDisorientationOrConfusion.SelectedItem != null && rblDisorientationOrConfusion.SelectedItem.Text != "No" && rblDisorientationOrConfusion.SelectedItem.Text != "Uncertain" && rblDisorientationOrConfusion.SelectedItem.Text != "Other condition not related to TBI or Behavioral Health condition(s)")
            {
                SaveSingleSelect(survey, questions, "7-A", rblDurationOfDisorientationOrConfusion);
            }
            SaveSingleSelect(survey, questions, "8", rblLossOfMemory);
            if (rblLossOfMemory.SelectedItem != null && rblLossOfMemory.SelectedItem.Text != "No" && rblLossOfMemory.SelectedItem.Text != "Uncertain" && rblLossOfMemory.SelectedItem.Text != "Other condition not related to TBI or Behavioral Health condition(s)")
            {
                SaveSingleSelect(survey, questions, "8-A", rblDurationOFMemoryLoss);
            }
            SaveSingleSelect(survey, questions, "9", rblObjectPenetration);
            SaveSingleSelect(survey, questions, "10", rblConsultationForNewInjury);
            SaveSingleSelect(survey, questions, "10-A", rblChangeMedicationForNewInjury);
        }
        SaveSingleSelect(survey, questions, "11-A", rblDizzyness);
        SaveSingleSelect(survey, questions, "11-B", rblLossOfBalance);
        SaveSingleSelect(survey, questions, "11-C", rblPoorCoordination);
        SaveSingleSelect(survey, questions, "11-D", rblHeadaches);
        SaveSingleSelect(survey, questions, "11-E", rblNausea);
        SaveSingleSelect(survey, questions, "11-F", rblVisionBlurring);
        SaveSingleSelect(survey, questions, "11-G", rblSensitivityToLight);
        SaveSingleSelect(survey, questions, "11-H", rblHearingDifficulty);
        SaveSingleSelect(survey, questions, "11-I", rblSensitivityToNoise);
        SaveSingleSelect(survey, questions, "11-J", rblNumbnessOrTingling);
        SaveSingleSelect(survey, questions, "11-K", rblChangeInTasteSmell);
        SaveSingleSelect(survey, questions, "11-L", rblAppetiteLossIncrease);
        SaveSingleSelect(survey, questions, "11-M", rblPoorConcentration);
        SaveSingleSelect(survey, questions, "11-N", rblForgetfulness);
        SaveSingleSelect(survey, questions, "11-O", rblDifficultyMakingDecisions);
        SaveSingleSelect(survey, questions, "11-P", rblSlowedThinking);
        SaveSingleSelect(survey, questions, "11-Q", rblListFatigue);
        SaveSingleSelect(survey, questions, "11-R", rblSleepDifficulty);
        SaveSingleSelect(survey, questions, "11-S", rblAnxiety);
        SaveSingleSelect(survey, questions, "11-T", rblDepression);
        SaveSingleSelect(survey, questions, "11-U", rblIrritability);
        SaveSingleSelect(survey, questions, "11-V", rblFrustration);
        SaveSingleSelect(survey, questions, "12", rblOverallInterferenceWithLife);
        if (rblOverallInterferenceWithLife.SelectedItem != null && rblOverallInterferenceWithLife.SelectedItem.Text != "Not at all" && rblOverallInterferenceWithLife.SelectedItem.Text != "Other condition not related to TBI or Behavioral Health condition(s)")
        {
            SaveText(survey, questions, "12-A", tbxAreasOfLifeAffected);
        }
        SaveSingleSelect(survey, questions, "13", rblProblemsWithPain);
        SaveMultiSelect(survey, questions, "13-A", cblProblemsWithPain, rblProblemsWithPain.SelectedValue == "5011");
        SaveSingleSelect(survey, questions, "13-B", rblPainInterferenceWithLife);
        SaveSingleSelect(survey, questions, "14", RadioButtonListOverallSymptomsSinceLastEval);
        SaveText(survey, questions, "15", tbxAdditionalComments);
        SaveText(survey, questions, "16", CurrentMedicationTextBox);
        SaveSingleSelect(survey, questions, "16-A", rblMedicationReconciliationPerformed);
        #region Non-standard (16-B and 16-C)
        if (rblMedicationReconciliationPerformed.SelectedItem != null && rblMedicationReconciliationPerformed.SelectedItem.Text.Contains("Yes") && rblMedicationGiven.SelectedIndex > -1)
        {
            List<STD_QUESTION_CHOICE> _list = GetQuestionChoices("16-B");
            SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
            SURVEY_RESULT inputResult = new SURVEY_RESULT() { STD_QUESTION_CHOICE_ID = _list.FirstOrDefault(a => a.CHOICE_SORT_ORDER == rblMedicationGiven.SelectedIndex + 1).STD_QUESTION_CHOICE_ID };
            SaveGeneric(survey, inputResult, currentResult, "16-B");
        }
        else
        {
            if (rblMedicationGiven.SelectedValue == "0")
            {
                List<STD_QUESTION_CHOICE> _list = GetQuestionChoices("16-B");
                SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
                SURVEY_RESULT inputResult = new SURVEY_RESULT() { STD_QUESTION_CHOICE_ID = _list.FirstOrDefault(a => a.CHOICE_SORT_ORDER == null).STD_QUESTION_CHOICE_ID };
                SaveGeneric(survey, inputResult, currentResult, "16-B");
            }
        }

        if (rblMedicationReconciliationPerformed.SelectedItem != null && rblMedicationReconciliationPerformed.SelectedItem.Text.Contains("No"))
        {
            List<STD_QUESTION_CHOICE> _list = GetQuestionChoices("16-C");
            SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
            SURVEY_RESULT inputResult = new SURVEY_RESULT() { STD_QUESTION_CHOICE_ID = _list.FirstOrDefault(a => a.CHOICE_SORT_ORDER == 1).STD_QUESTION_CHOICE_ID, RESULT_TEXT = txtNoMedicationReconciliationPerformed.Text.Trim() };
            SaveGeneric(survey, inputResult, currentResult, "16-C");
        }
        else
        {
            List<STD_QUESTION_CHOICE> _list = GetQuestionChoices("16-C");
            SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
            SURVEY_RESULT inputResult = new SURVEY_RESULT() { STD_QUESTION_CHOICE_ID = _list.FirstOrDefault(a => a.CHOICE_SORT_ORDER == 1).STD_QUESTION_CHOICE_ID, RESULT_TEXT = null };
            SaveGeneric(survey, inputResult, currentResult, "16-C");
        }
        #endregion Non-standard (16-B and 16-C)
        SaveText(survey, questions, "17", tbxPhysicalExam);
        SaveText(survey, questions, "18", tbxProfessionalAssessment);
        SaveSingleSelect(survey, questions, "19", rblExperiencedNewTbi);
        SaveSingleSelect(survey, questions, "19-A", RadioButtonListClinicalJudgement);
        if (RadioButtonListClinicalJudgement.SelectedItem != null && RadioButtonListClinicalJudgement.SelectedItem.Text == "Other condition not related to TBI or Behavioral Health condition(s)")
        {
            SaveText(survey, questions, "19-A-1", OtherConditionDetailsTextBox);
        }
        SaveSingleSelect(survey, questions, "20", rblFollowUpPlan);
        SaveText(survey, questions, "21", tbxDetailsOfPlan);
    }

    private void SaveMultiSelect(SURVEY survey, List<STD_QUESTION> questions, string questionNumber, CheckBoxList checkBoxList, bool addNullCondition)
    {
        List<STD_QUESTION_CHOICE> _list = GetQuestionChoices(questionNumber);
        SURVEY_RESULT[] currentResults = survey.SURVEY_RESULTs.Where(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null).ToArray();
        selectedItems = 0;
        foreach (ListItem item in checkBoxList.Items)
        {
            var selection = currentResults.Where(c => c.STD_QUESTION_CHOICE_ID == int.Parse(item.Value)).FirstOrDefault();
            if (item.Selected)
            {
                selectedItems++;
                if (selection != null)
                {
                    //found it so it was here and no need to add it
                    selection.SetAsNoChangeOnSubmit();
                }
                else
                {
                    //have not found it so need to add it.
                    SURVEY_RESULT result = new SURVEY_RESULT() { STD_QUESTION_CHOICE_ID = int.Parse(item.Value) };
                    survey.SURVEY_RESULTs.Add(result);
                }
            }
            //else it is already marked for deletion if it exists
        }
        if (selectedItems == 0)
        {
            if (addNullCondition)
            {
                SURVEY_RESULT result = new SURVEY_RESULT() { STD_QUESTION_CHOICE_ID = _list[0].STD_QUESTION_CHOICE_ID };
                survey.SURVEY_RESULTs.Add(result);
            }

        }
        //the null one is already marked for deletion so nothing else to do
    }

    private void SaveText(SURVEY survey, List<STD_QUESTION> questions, string questionNumber, TextBox textBox)
    {
        List<STD_QUESTION_CHOICE> _list = GetQuestionChoices(questionNumber);
        SURVEY_RESULT inputResult = new SURVEY_RESULT() 
        {
            RESULT_TEXT = textBox.Text,
            STD_QUESTION_CHOICE_ID = _list.FirstOrDefault(item => item.CHOICE_SORT_ORDER != null).STD_QUESTION_CHOICE_ID //_list[0].STD_QUESTION_CHOICE_ID 
        };
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
        SaveGeneric(survey, inputResult, currentResult, questionNumber);
    }

    private void SaveGeneric(SURVEY survey, SURVEY_RESULT inputResult, SURVEY_RESULT currentResult, string questionNumber)
    {
        if (currentResult == null)
        {
            survey.SURVEY_RESULTs.Add(inputResult);
        }
        else if (currentResult.STD_QUESTION_CHOICE_ID != inputResult.STD_QUESTION_CHOICE_ID || currentResult.RESULT_TEXT != inputResult.RESULT_TEXT)
        {
            //currentResult.SetAsDeleteOnSubmit();
            survey.SURVEY_RESULTs.Add(inputResult);
        }
        else
        {
            currentResult.SetAsNoChangeOnSubmit();
            System.Diagnostics.Debug.WriteLine("No update required for question " + questionNumber);
        }
    }

    private void SaveSingleSelect(SURVEY survey, List<STD_QUESTION> questions, string questionNumber, RadioButtonList radioButtonList)
    {
        List<STD_QUESTION_CHOICE> _list = GetQuestionChoices(questionNumber);
        SURVEY_RESULT inputResult = BuildInputResult(radioButtonList, _list[0]);
        if (IsNotAsked(inputResult.RESULT_TEXT))
            return;//just allow the item to be deleted
        SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => _list.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
        SaveGeneric(survey, inputResult, currentResult, questionNumber);
    }

    private SURVEY_RESULT BuildInputResult(RadioButtonList radioButtonList, STD_QUESTION_CHOICE missingChoice)
    {
        SURVEY_RESULT result = new SURVEY_RESULT();
        if (radioButtonList.SelectedIndex > -1)
        {
            // Add Question 1 choice
            result.STD_QUESTION_CHOICE_ID = Convert.ToInt32(radioButtonList.SelectedValue);
            result.RESULT_TEXT = radioButtonList.SelectedItem.Text;
        }
        else
        {
            //List<STD_QUESTION_CHOICE> _list = GetQuestionChoices("1");
            result.STD_QUESTION_CHOICE_ID = missingChoice.STD_QUESTION_CHOICE_ID;
            result.RESULT_TEXT = missingChoice.CHOICE_TEXT.ToString();
        }
        return result;
    }

    // END SaveSurvey

    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey)
    {
        try
        {
            foreach (var sResult in survey.SURVEY_RESULTs)
            {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                {
                    case "A": SetTextBoxElement("A", TextBoxChiefComplaint, sResult); break;
                    case "B": SetTextBoxElement("B", TextBoxHistoryPresentIllness, sResult); break;
                    case "1": SetRadioElement("1", RadioButtonListChangeInMaritalStatus, sResult); break;
                    case "2": SetRadioElement("2", RadioButtonListHighestEducationalLevel, sResult); break;
                    case "2-A": SetRadioElement("2-A", RadioButtonListCurrentSchool, sResult); break;
                    case "3": SetRadioElement("3", RadioButtonListCurrentEmploymentStatus, sResult); break;
                    case "4": SetRadioElement("4", rblExperiencedHeadInjury, sResult); break;
                    case "4-A": SetTextBoxElement("4-A", tbxMonthOfRecentHeadInjury, sResult); break;
                    case "4-B": SetTextBoxElement("4-B", tbxYearOfRecentHeadInjury, sResult); break;
                    case "5-A": SetRadioElement("5-A", rblBullet, sResult); break;
                    case "5-B": SetRadioElement("5-B", rblVehicular, sResult); break;
                    case "5-C": SetRadioElement("5-C", rblFall, sResult); break;
                    case "5-D": SetRadioElement("5-D", rblBlastOccurrences, sResult); break;
                    case "5-D-1": SetRadioElement("5-D-1", rblBlastWaveExperience, sResult); break;
                    case "5-D-1-A": SetRadioElement("5-D-1-A", rblEstimatedBlastDistance, sResult); break;
                    case "5-D-2": SetRadioElement("5-D-2", rblBlastWaveWindExperience, sResult); break;
                    case "5-D-3": SetRadioElement("5-D-3", rblBlastWaveCausingViolentImpact, sResult); break;
                    case "5-D-4": SetRadioElement("5-D-4", rblBlastExplosionCausingInjuries, sResult); break;
                    case "5-D-5": SaveCheckAnswer(sResult.STD_QUESTION_CHOICE, _FiveDFiveAAnswers); break;
                    case "5-E": SetRadioElement("5-E", rblBluntTraumaOtherThanFromBlast, sResult); break;
                    case "6": SetRadioElement("6", rblLossOfConsciousness, sResult); break;
                    case "6-A": SetRadioElement("6-A", rblDurationLossOfConsciousness, sResult); break;
                    case "7": SetRadioElement("7", rblDisorientationOrConfusion, sResult); break;
                    case "7-A": SetRadioElement("7-A", rblDurationOfDisorientationOrConfusion, sResult); break;
                    case "8": SetRadioElement("8", rblLossOfMemory, sResult); break;
                    case "8-A": SetRadioElement("8-A", rblDurationOFMemoryLoss, sResult); break;
                    case "9": SetRadioElement("9", rblObjectPenetration, sResult); break;
                    case "10": SetRadioElement("10", rblConsultationForNewInjury, sResult); break;
                    case "10-A": SetRadioElement("10-A", rblChangeMedicationForNewInjury, sResult); break;
                    case "11-A": SetRadioElement("11-A", rblDizzyness, sResult); break;
                    case "11-B": SetRadioElement("11-B", rblLossOfBalance, sResult); break;
                    case "11-C": SetRadioElement("11-C", rblPoorCoordination, sResult); break;
                    case "11-D": SetRadioElement("11-D", rblHeadaches, sResult); break;
                    case "11-E": SetRadioElement("11-E", rblNausea, sResult); break;
                    case "11-F": SetRadioElement("11-F", rblVisionBlurring, sResult); break;
                    case "11-G": SetRadioElement("11-G", rblSensitivityToLight, sResult); break;
                    case "11-H": SetRadioElement("11-H", rblHearingDifficulty, sResult); break;
                    case "11-I": SetRadioElement("11-I", rblSensitivityToNoise, sResult); break;
                    case "11-J": SetRadioElement("11-J", rblNumbnessOrTingling, sResult); break;
                    case "11-K": SetRadioElement("11-K", rblChangeInTasteSmell, sResult); break;
                    case "11-L": SetRadioElement("11-L", rblAppetiteLossIncrease, sResult); break;
                    case "11-M": SetRadioElement("11-M", rblPoorConcentration, sResult); break;
                    case "11-N": SetRadioElement("11-N", rblForgetfulness, sResult); break;
                    case "11-O": SetRadioElement("11-O", rblDifficultyMakingDecisions, sResult); break;
                    case "11-P": SetRadioElement("11-P", rblSlowedThinking, sResult); break;
                    case "11-Q": SetRadioElement("11-Q", rblListFatigue, sResult); break;
                    case "11-R": SetRadioElement("11-R", rblSleepDifficulty, sResult); break;
                    case "11-S": SetRadioElement("11-S", rblAnxiety, sResult); break;
                    case "11-T": SetRadioElement("11-T", rblDepression, sResult); break;
                    case "11-U": SetRadioElement("11-U", rblIrritability, sResult); break;
                    case "11-V": SetRadioElement("11-V", rblFrustration, sResult); break;
                    case "12": SetRadioElement("12", rblOverallInterferenceWithLife, sResult); break;
                    case "12-A": SetTextBoxElement("12-A", tbxAreasOfLifeAffected, sResult); break;
                    case "13": SetRadioElement("13", rblProblemsWithPain, sResult); break;
                    case "13-A": SaveCheckAnswer(sResult.STD_QUESTION_CHOICE, _ThirteenAAnswers); break;
                    case "13-B": SetRadioElement("13-B", rblPainInterferenceWithLife, sResult); break;
                    case "14": SetRadioElement("14", RadioButtonListOverallSymptomsSinceLastEval, sResult); break;
                    case "15": SetTextBoxElement("15", tbxAdditionalComments, sResult); break;
                    case "16": SetTextBoxElement("16", CurrentMedicationTextBox, sResult); break;
                    case "16-A": rblMedicationReconciliationPerformed.SelectedIndex = sResult.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue ? sResult.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.Value - 1 : -1; break;
                    case "16-B": rblMedicationGiven.SelectedIndex = sResult.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.HasValue ? sResult.STD_QUESTION_CHOICE.CHOICE_SORT_ORDER.Value - 1 : -1; break;
                    case "16-C": txtNoMedicationReconciliationPerformed.Text = sResult.RESULT_TEXT; break;
                    case "17": SetTextBoxElement("17", tbxPhysicalExam, sResult); break;
                    case "18": SetTextBoxElement("18", tbxProfessionalAssessment, sResult); break;
                    case "19": SetRadioElement("19", rblExperiencedNewTbi, sResult); break;
                    case "19-A": SetRadioElement("19-A", RadioButtonListClinicalJudgement, sResult); break;
                    case "19-A-1": SetTextBoxElement("19-A-1", OtherConditionDetailsTextBox, sResult); break;
                    case "20": SetRadioElement("20", rblFollowUpPlan, sResult); break;
                    case "21": SetTextBoxElement("21", tbxDetailsOfPlan, sResult); break;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "InstrumentFollowUpEntry.aspx", "100027", "SetUpSurvey()");
        }
    }

    private bool IsNotAsked(string s)
    {
        if (string.IsNullOrEmpty(s))
            return false;
        return s.IndexOf("not asked", StringComparison.OrdinalIgnoreCase) != -1;
    }

    private void SaveCheckAnswer(STD_QUESTION_CHOICE choice, List<string> answerList)
    {
        if (!IsNotAsked(choice.CHOICE_TEXT))
            answerList.Add(choice.STD_QUESTION_CHOICE_ID.ToString());
    }
    // END SetUpSurvey

    private void SetTextBoxElement(string _elementRef, TextBox _elementObj, SURVEY_RESULT _result)
    {
        if (!IsNotAsked(_result.RESULT_TEXT))
            _elementObj.Text = _result.RESULT_TEXT;
    }
    private void SetRadioElement(string _elementRef, RadioButtonList _elementObj, SURVEY_RESULT _result)
    {
        if (_result.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
        {
            if (!IsNotAsked(_result.RESULT_TEXT))
            {
                _elementObj.SelectedValue = _result.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
            }
        }
        else
        {
            _elementObj.SelectedIndex = -1;
        }
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId)
    {
        foreach (STD_QUESTION ques in VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions())
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower())
            {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber)
    {
        foreach (STD_QUESTION ques in VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions())
        {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower())
            {
                return ques.ID;
            }
        }
        return 0;
    }
    #endregion

    /// <summary>
    /// Calculate total score.
    /// </summary>
    protected void FillFormFields()
    {

    }

    #region DataBound events

    protected void RadioButtonList_Common_OnDataBound(object sender, EventArgs e)
    {
        //Fortify does not like this line (sender as RadioButtonList).Items.RemoveAt(0);
        ((RadioButtonList)sender).Items.RemoveAt(0);
    }
    private void CheckBoxListCommonDataBound(CheckBoxList cbl, string questionNumber, List<string> answers)
    {
        cbl.Items.RemoveAt(0);
        List<STD_QUESTION> questions = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestions();
        STD_QUESTION question = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == questionNumber);
        if (question.STD_QUESTION_CHOICEs != null)
        {
            if (question.STD_QUESTION_CHOICEs.HasLoadedOrAssignedValues)
            {
                foreach (string _item in answers)
                {
                    if (!IsNotAsked(_item) && !"null".Equals(_item, StringComparison.OrdinalIgnoreCase))
                        cbl.Items.FindByValue(_item.ToString()).Selected = true;
                }
            }
        }
    }
    protected void cblProblemsWithPain_OnDataBound(object sender, EventArgs e)
    {
        CheckBoxListCommonDataBound(cblProblemsWithPain, "13-A", _ThirteenAAnswers);
    }
    protected void CheckBoxListTypeOfBlastExposures_OnDataBound(object sender, EventArgs e)
    {
        CheckBoxListCommonDataBound(CheckBoxListTypeOfBlastExposures, "5-D-5", _FiveDFiveAAnswers);
    }

    #endregion
}
